%% N2 + Ar, 1 bar + 6bar, scan YAG
% PB_TESTING2511y14
% Tvalve = -140 deg C

% all traces together

close all
clear all

defaultfolder = pwd;

set(0,'defaulttextinterpreter','latex')
set(0,'DefaultTextFontname', 'Symbol')
set(0,'DefaultAxesFontName', 'Symbol')

str1 = 'N2Ar_460mps_m1_15musincpl.txt';
str2 = 'N2Ar_460mps_m1_15musincpl_2.txt';
str3 = 'N2Ar_460mps_m1_15musincpl_3.txt';
str4 = 'N2Ar_460mps_m1_15musincpl_4.txt';
str5 = 'N2Ar_460mps_m1_15musincpl_5.txt';

cd('50mus')

s1 = load(str1);
s2 = load(str2);
s3 = load(str3);
s4 = load(str4);
s5 = load(str5);

smean(:,1) = (s1(:,2)+s2(:,2)+s3(:,2)+s4(:,2)+s5(:,2))/5;
smean(:,2) = (s1(:,3)+s2(:,3)+s3(:,3)+s4(:,3)+s5(:,3))/5;

trace = [s1(:,1) smean];

dlmwrite('N2Ar_400mps_ALL_m1_15musincpl_50mus.txt', trace, 'delimiter', '\t','precision', 12)

%% TOF scan, plot all

figure_width  = 8;
figure_height = 4.5;
FontSize = 9;
% FontName = 'Arial';
LineWidth = 0.7;

figure10 = figure(10);
hold on
plot(s5(:,1),smean(:,1)/max(smean(:,2)),'r-','LineWidth',1.5)
plot(s5(:,1),smean(:,2)/max(smean(:,2)),'k-','LineWidth',1.5)
hold off
xlabel('TOF ($\mu$s)','FontSize',FontSize)
ylabel('Signal (arb.)','FontSize',FontSize)
% hll = legend('$^2$D$_{3/2}$','$^2$D$_{5/2}$','Location',[0.3 0.7 0.1 0.1]);
% legend boxoff
% set(hll,'PlotBoxAspectRatioMode','manual');
% set(hll,'PlotBoxAspectRatio',[0.5 1 1]);
axis([400 750 0 1.2])

set(gca, ...
  'FontSize'    , FontSize , ...
  'Box'         , 'on'     , ...
  'TickDir'     , 'in'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'off'      , ...
  'YMinorTick'  , 'off'      , ...
  'XGrid'       , 'off'      , ...
  'YGrid'       , 'off'      , ...
  'XTick'       , 0:100:1000, ...
  'YTick'       , 0:0.3:1.2, ...
  'LineWidth'   , LineWidth);


set(gcf, 'units', 'centimeters', 'pos', [8 8 figure_width figure_height])
% set(gcf, 'Units', 'pixels', 'Position', [100 100 500 375]);
set(gcf, 'PaperPositionMode', 'auto');
set(gcf, 'Color', [1 1 1]); % Sets figure background
set(gca, 'Color', [1 1 1]); % Sets axes background
set(gcf, 'Renderer', 'painters');

print(figure10,'-depsc','N2Ar_400mps_ALL_m1_15musincpl_50mus','-r1000')
% print(figure10,'-djpeg','N2Ar_400mps_ALL_m1_15musincpl_50mus','-r300')

cd(defaultfolder)
